/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DecimalPlacePanel;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnalogWatchdogPanel
extends AbstractProtectionPanel {
    private MeasurementPanel fMeasurementPanel;
    private DecimalPlacePanel fDecimalPlacesPanel;
    private JLabel fLblDeltaTriggerDescription;
    private EditableNumericSpinner fDeltaTriggerSpinner;
    private IntegerOrReferencePanel fDeltaTriggerSpinner01;
    private IntegerOrReferencePanel fDeltaTriggerSpinner02;

    public AnalogWatchdogPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initComponents((AnalogWatchdogParameter)parameterReference);
    }

    private void initComponents(AnalogWatchdogParameter parameterReference) {
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        this.fMeasurementPanel = new MeasurementPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        parameterPanel.add((Component)this.fMeasurementPanel, gbc);
        JPanel triggerBorder = new JPanel();
        triggerBorder.setLayout(new GridBagLayout());
        this.fLblDeltaTriggerDescription = new JLabel("Trigger (delta)");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 2, 0, 2);
        triggerBorder.add((Component)this.fLblDeltaTriggerDescription, gbc);
        this.fDeltaTriggerSpinner = new EditableNumericSpinner();
        this.fDeltaTriggerSpinner.setColumns(6);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        triggerBorder.add((Component)this.fDeltaTriggerSpinner, gbc);
        this.fDeltaTriggerSpinner01 = new IntegerOrReferencePanel();
        this.fDeltaTriggerSpinner01.setReferenceVisability(parameterReference.isValueOrReference());
        this.fDeltaTriggerSpinner01.setBounds(121, 16, 70, 22);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 2, 0, 2);
        triggerBorder.add((Component)this.fDeltaTriggerSpinner01, gbc);
        this.fDeltaTriggerSpinner02 = new IntegerOrReferencePanel();
        this.fDeltaTriggerSpinner02.setReferenceVisability(parameterReference.isValueOrReference());
        this.fDeltaTriggerSpinner02.setBounds(121, 16, 70, 22);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 2, 2, 2);
        triggerBorder.add((Component)this.fDeltaTriggerSpinner02, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        parameterPanel.add((Component)triggerBorder, gbc);
        this.fDecimalPlacesPanel = new DecimalPlacePanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 16;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 5, 0, 5);
        parameterPanel.add((Component)this.fDecimalPlacesPanel, gbc);
        this.addParameterPane(parameterPanel);
        if (parameterReference.getBlock().getHardware().supports("analogWatchdogWithTwoDelta")) {
            this.fLblDeltaTriggerDescription.setVisible(false);
            this.fDeltaTriggerSpinner.setVisible(false);
        } else {
            this.fDeltaTriggerSpinner01.setVisible(false);
            this.fDeltaTriggerSpinner02.setVisible(false);
        }
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        AnalogWatchdogParameter analogWatchdogParameter = (AnalogWatchdogParameter)this.fParameterReference;
        this.fMeasurementPanel.setModel(analogWatchdogParameter.getMeasurement());
        try {
            this.fMeasurementPanel.loadFieldContents();
        }
        catch (ProgramException e) {
            e.printStackTrace();
        }
        WiringDiagram wiringDiagram = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        ArrayList blocksForReference = wiringDiagram.getBlocksForReference(notIncluded, true);
        this.fDeltaTriggerSpinner01.setReferenceList(blocksForReference);
        this.fDeltaTriggerSpinner02.setReferenceList(blocksForReference);
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.loadFieldContents();
        this.fDeltaTriggerSpinner.setProperties(analogWatchdogParameter.getDeltaProperties());
        this.fDeltaTriggerSpinner01.setProperties(analogWatchdogParameter.getDeltaTrigger01());
        this.fDeltaTriggerSpinner02.setProperties(analogWatchdogParameter.getDeltaTrigger02());
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.loadFieldContents();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        AnalogWatchdogParameter analogWatchdogParameter = (AnalogWatchdogParameter)this.fParameterReference;
        this.fMeasurementPanel.storeFieldContents();
        this.fDecimalPlacesPanel.storeFieldContents();
        if (this.fDeltaTriggerSpinner.isVisible()) {
            analogWatchdogParameter.setDelta01(this.fDeltaTriggerSpinner.getValue());
            analogWatchdogParameter.setDelta02(this.fDeltaTriggerSpinner.getValue());
        } else {
            analogWatchdogParameter.setDelta01(this.fDeltaTriggerSpinner01.getValue());
            analogWatchdogParameter.setDelta02(this.fDeltaTriggerSpinner02.getValue());
        }
    }

    public void setLabels() {
        super.setLabels();
        this.fMeasurementPanel.setLabels();
        this.fLblDeltaTriggerDescription.setText(Language.getString("dialog.parameter.analogWatchdog.trigger", "Trigger (delta)"));
        this.fDeltaTriggerSpinner01.setTitle(Language.getString("dialog.parameter.analogWatchdog.trigger01", "Trigger1 (delta)"));
        this.fDeltaTriggerSpinner02.setTitle(Language.getString("dialog.parameter.analogWatchdog.trigger02", "Trigger2 (delta)"));
        this.fDecimalPlacesPanel.setLabels();
    }

    public boolean checkChanged() {
        AnalogWatchdogParameter analogWatchdogParameter = (AnalogWatchdogParameter)this.fParameterReference;
        boolean deltaChanged = this.fDeltaTriggerSpinner.isVisible() ? analogWatchdogParameter.getDelta() != this.fDeltaTriggerSpinner.getValue() : this.fDeltaTriggerSpinner01.checkChanged() || this.fDeltaTriggerSpinner02.checkChanged();
        return super.checkChanged() || deltaChanged || this.fMeasurementPanel.checkChanged() || this.fDecimalPlacesPanel.checkChanged();
    }

    public boolean checkFieldContents() {
        return super.checkFieldContents() && this.fDeltaTriggerSpinner.checkValue(true) && this.fDeltaTriggerSpinner01.checkValue(true) && this.fDeltaTriggerSpinner02.checkValue(true) && this.fMeasurementPanel.checkFieldContents() && this.fDecimalPlacesPanel.checkFieldContents();
    }
}

